#include "ScnFileBrowser.h"
#include "scnutilities.h"
#include "scnfileop.h"
#include <direct.h>

#include <vector>
#include <map>
#include "xmedia.h"

using namespace std;

HRESULT CScnFileBrowser::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
	OverlapFunc = 0;

 	DebugMsg("CScnFileBrowser::OnInit");

    GetChildById( L"TitleText", &m_title );
    GetChildById( L"CopyText", &m_copytext );
    GetChildById( L"FileList", &m_filelist );
    GetChildById( L"BackButton", &m_back );
    GetChildById( L"Drive", &m_drive );
    GetChildById( L"ChooseDrive", &m_choosedrive );
    GetChildById( L"Copy", &m_copy );
    GetChildById( L"Cut", &m_cut );
    GetChildById( L"Paste", &m_paste );
    GetChildById( L"Rename", &m_rename );
    GetChildById( L"Delete", &m_delete );
    GetChildById( L"MakeDir", &m_makedir );
    GetChildById( L"Video", &m_video );
	
	m_title.SetText(L"Starting");

	//BasePaths

	BasePaths.clear();

	if (Mounted[DEVICE_USB0])
		BasePaths.push_back("Usb0:");
	if (Mounted[DEVICE_USB1])
		BasePaths.push_back("Usb1:");
	if (Mounted[DEVICE_USB2])
		BasePaths.push_back("Usb2:");
	if (Mounted[DEVICE_HARDISK0_PART1])
		BasePaths.push_back("Hdd1:");
	if (Mounted[DEVICE_HARDISK0_SYSPART])
		BasePaths.push_back("HddX:");
	if (Mounted[DEVICE_MEMORY_UNIT0])
		BasePaths.push_back("Memunit0:");
	if (Mounted[DEVICE_MEMORY_UNIT1])
		BasePaths.push_back("Memunit1:");
	if (Mounted[DEVICE_MEMORY_ONBOARD])
		BasePaths.push_back("OnBoardMU:");
	if (Mounted[DEVICE_NAND_FLASH])
		BasePaths.push_back("Flash:");
	if (Mounted[DEVICE_CDROM0])
		BasePaths.push_back("Dvd:");
	BasePaths.push_back("Game:");

	if (FL_BaseDir.empty())
	{
		FL_BaseDir = (*BasePaths.begin());
		FL_CurrentDir = "";
	}

	XUIMessage xuiMsg;
	XuiMessage(&xuiMsg,XM_FILES_REFRESH);
	XuiSendMessage( m_filelist, &xuiMsg );

	BOOL Temp = FALSE;
	OnDirChange(Temp);

	IsCut = false;

	return S_OK;
}

WCHAR DefaultName[1024];
WCHAR MessageText[1024];

HRESULT CScnFileBrowser::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{
	if (hObjPressed == m_back)
	{
		if (!FL_CurrentDir.empty())
		{
			XUIMessage xuiMsg;
			XuiMessage(&xuiMsg,XM_FILES_DOBACK);
			XuiSendMessage( m_filelist, &xuiMsg );
			
			bHandled = TRUE;
		}		
	} else if (hObjPressed == m_drive)
	{
		vector<string>::iterator itr;
		for (itr = BasePaths.begin() ; itr != BasePaths.end() ; itr++)
		{
			if (*itr == FL_BaseDir)
			{
				itr++;
				if (itr != BasePaths.end())
				{
					FL_BaseDir = (*itr);
				} else {
					itr = BasePaths.begin();
					FL_BaseDir = (*itr);
				}
				break;
			}
		}

		FL_CurrentDir = "";
		XUIMessage xuiMsg;
		XuiMessage(&xuiMsg,XM_FILES_REFRESH);
		XuiSendMessage( m_filelist, &xuiMsg );
	} else if (hObjPressed == m_choosedrive)
	{
		
	} else if (hObjPressed == m_delete)
	{
		IsCut = false;
		copysource = FL_BaseDir + "\\" + FL_CurrentDir + "\\" + FL_CurrentFile;
		copysource = str_replaceallA(copysource,"\\\\","\\");
		CD_Action = CDA_DELETE;
		CD_Source = copysource;
		CD_Dest = CD_Source;

		OverlapFunc = 3;
		memset(&overlapped,0,sizeof(overlapped));
		string message = sprintfaA("Are you sure you want to delete %s",copysource.c_str());
		wcscpy_s(MessageText,1024,strtowstr(message).c_str());
		XShowMessageBoxUI(0,L"Delete file",MessageText,2,btnYesNo,1,XMB_WARNINGICON,&mbresult,&overlapped);
		SetTimer(TM_OVERLAPPED,50);
		bHandled = TRUE;

	} else if (hObjPressed == m_copy)
	{
		IsCut = false;
		copysource = FL_BaseDir + "\\" + FL_CurrentDir + "\\" + FL_CurrentFile;
		copysource = str_replaceallA(copysource,"\\\\","\\");
		copyfile = FL_CurrentFile;
		string text = "Copy : " + copysource;
		m_copytext.SetText(strtowstr(text).c_str());
		bHandled = TRUE;
	} else if (hObjPressed == m_cut)
	{
		IsCut = true;
		copysource = FL_BaseDir + "\\" + FL_CurrentDir + "\\" + FL_CurrentFile;
		copysource = str_replaceallA(copysource,"\\\\","\\");
		copyfile = FL_CurrentFile;
		string text = "Cut : " + copysource;
		m_copytext.SetText(strtowstr(text).c_str());
		bHandled = TRUE;
	} else if (hObjPressed == m_paste)
	{
		string dest = FL_BaseDir + "\\" + FL_CurrentDir + "\\" + copyfile;
		dest = str_replaceallA(dest,"\\\\","\\");
		DebugMsg("Copy %s to %s",copysource.c_str(),dest.c_str());
		
		CD_Source = copysource;
		CD_Dest = dest;
		if (IsCut)
			CD_Action = CDA_MOVEFILES;
		else 
			CD_Action = CDA_COPYFILES;

		if (IsFolder(copysource))
		{
			CD_Dest.append("\\");
			CD_Dest = str_replaceallA(CD_Dest,"\\\\","\\");
			_mkdir(CD_Dest.c_str());
		}

		if (dest.substr(0,copysource.size()) == copysource)
		{
			memset(&mbresult,0,sizeof(mbresult));
			memset(&overlapped,0,sizeof(overlapped));
			XShowMessageBoxUI(0,L"Cannot copy",L"Cannot copy, destination folder is within the source folder.",1,btnOk,0,XMB_ERRORICON,&mbresult,&overlapped);
			bHandled = TRUE;
			return S_OK;
		}

		if (IsCut)
		{

			string srcdrive = copysource.substr(0,copysource.find(":"));
			string dstdrive = dest.substr(0,dest.find(":"));

			if (srcdrive == dstdrive)
			{
				CD_Action = CDA_SDMODE;
			}
		}

		copysource = "";
		m_copytext.SetText(L"No copied files");

		CD_Done = false;
		SetTimer(TM_OPERATIONDONE,50);

		HXUIOBJ hScene = NULL;
		HRESULT hResult = CXuiScene::SceneCreate( L"fileop.xur", &hScene );
		hResult = CXuiScene::NavigateForward( hScene );

		bHandled = TRUE;
	} else if (hObjPressed == m_rename)
	{
		IsCut = true;
		string source = FL_BaseDir + "\\" + FL_CurrentDir + "\\" + FL_CurrentFile;
		source = str_replaceallA(source,"\\\\","\\");

		memset(result,0,sizeof(result));
		memset(&overlapped,0,sizeof(overlapped));
		wcscpy_s(DefaultName,1024,strtowstr(FL_CurrentFile).c_str());

		string message = sprintfaA("Please enter new name for file %s",source.c_str());
		wcscpy_s(MessageText,1024,strtowstr(message).c_str());
		HRESULT hr = XShowKeyboardUI(0,VKBD_DEFAULT|VKBD_HIGHLIGHT_TEXT,DefaultName,L"Please enter new name",MessageText,result,1024,&overlapped);
		if (ERROR_IO_PENDING == hr)
		{
			DebugMsg("XShowKeyboardUI OK - ERROR_IO_PENDING");
			OverlapFunc = 1;
		}
		SetTimer(TM_OVERLAPPED,50);

		bHandled = TRUE;
	} else if (hObjPressed == m_makedir)
	{
		IsCut = true;
		string source = FL_BaseDir + "\\" + FL_CurrentDir + "\\";
		source = str_replaceallA(source,"\\\\","\\");

		memset(result,0,sizeof(result));
		memset(&overlapped,0,sizeof(overlapped));

		string message = sprintfaA("Please enter new directory name in %s",source.c_str());
		wcscpy_s(MessageText,1024,strtowstr(message).c_str());
		HRESULT hr = XShowKeyboardUI(0,VKBD_DEFAULT|VKBD_HIGHLIGHT_TEXT,L"New Folder",L"Please enter new directory name",MessageText,result,1024,&overlapped);
		if (ERROR_IO_PENDING == hr)
		{
			DebugMsg("XShowKeyboardUI OK - ERROR_IO_PENDING");
			OverlapFunc = 2;
		}
		SetTimer(TM_OVERLAPPED,50);

		bHandled = TRUE;
	}
	return S_OK;
} 

HRESULT CScnFileBrowser::OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled )
{
	switch (pTimer->nId)
	{
	case TM_OVERLAPPED:
		{
			if (OverlapFunc == 1)
			{
				if (XHasOverlappedIoCompleted(&overlapped))
				{
					if (overlapped.dwExtendedError == ERROR_SUCCESS)
					{
						string newname = wstrtostr(result);
						string source = FL_BaseDir + "\\" + FL_CurrentDir + "\\" + FL_CurrentFile;
						source = str_replaceallA(source,"\\\\","\\");

						string dest = FL_BaseDir + "\\" + FL_CurrentDir + "\\" + newname;
						dest = str_replaceallA(dest,"\\\\","\\");

						MoveFile(source.c_str(),dest.c_str());

						XUIMessage xuiMsg;
						XuiMessage(&xuiMsg,XM_FILES_REFRESH);
						XuiSendMessage( m_filelist, &xuiMsg );

						//DebugMsg("Rename %s to %s",source.c_str(),dest.c_str());
					}
					KillTimer(TM_OVERLAPPED);
					OverlapFunc = 0;
				}
			}
			if (OverlapFunc == 2)
			{
				if (XHasOverlappedIoCompleted(&overlapped))
				{
					if (overlapped.dwExtendedError == ERROR_SUCCESS)
					{
						string newname = wstrtostr(result);
						string dest = FL_BaseDir + "\\" + FL_CurrentDir + "\\" + newname;
						dest = str_replaceallA(dest,"\\\\","\\");

						//DebugMsg("Making dir %s",dest.c_str());
						_mkdir(dest.c_str());

						XUIMessage xuiMsg;
						XuiMessage(&xuiMsg,XM_FILES_REFRESH);
						XuiSendMessage( m_filelist, &xuiMsg );

						//DebugMsg("Rename %s to %s",source.c_str(),dest.c_str());
					}
					KillTimer(TM_OVERLAPPED);
					OverlapFunc = 0;
				}
			}
			if (OverlapFunc == 3)
			{
				if (XHasOverlappedIoCompleted(&overlapped))
				{
					if (overlapped.dwExtendedError == ERROR_SUCCESS)
					{
						//DebugMsg("Result of delete mb : %d",mbresult.dwButtonPressed);
						if (mbresult.dwButtonPressed == 0)
						{
							//DebugMsg("Deleting %s",copysource.c_str());

							if (IsFolder(copysource))
							{
								CD_Done = false;
								SetTimer(TM_OPERATIONDONE,50);
								HXUIOBJ hScene = NULL;
								HRESULT hResult = CXuiScene::SceneCreate( L"fileop.xur", &hScene );
								hResult = CXuiScene::NavigateForward( hScene );
							} else {
								_unlink(copysource.c_str());
								XUIMessage xuiMsg;
								XuiMessage(&xuiMsg,XM_FILES_REFRESH);
								XuiSendMessage( m_filelist, &xuiMsg );
							}

						}
					}
					KillTimer(TM_OVERLAPPED);
					OverlapFunc = 0;
				}
			}
		}
	case TM_OPERATIONDONE:
		{
			if (CD_Done)
			{
				XUIMessage xuiMsg;
				XuiMessage(&xuiMsg,XM_FILES_REFRESH);
				XuiSendMessage( m_filelist, &xuiMsg );
				KillTimer(TM_OPERATIONDONE);
				CD_Done = false;
			}
		}
		break;
	}
	return S_OK;
}

HRESULT CScnFileBrowser::OnFilesChange( BOOL& bHandled )
{
	return S_OK;
}

HRESULT CScnFileBrowser::OnDirChange( BOOL& bHandled )
{
	string text = FL_BaseDir + FL_CurrentDir;
	if (FL_CurrentDir.empty())
		text.append("\\");
	m_title.SetText(strtowstr(text).c_str());
	return S_OK;
}

HRESULT CScnFileBrowser::OnFilePress( BOOL& bHandled )
{
	string file = FL_BaseDir + "\\" + FL_CurrentDir + "\\" + FL_CurrentFile;
	file = str_replaceallA(file,"\\\\","\\");
	string text = "Pressed " + file;
	m_copytext.SetText(strtowstr(text).c_str());

	string ext = make_lowercaseA(FileExtA(file));

	if (ext == "xex")
	{
		XLaunchNewImage(file.c_str(),0);
	} else if (ext == "wmv")
	{
		XMediaCreateXmvPlayerFromFile(pDevice,file.c_str(),&xmvPlayer);
		m_video.SetPlayer(xmvPlayer);
	} else if (ext == "xbe")
	{
		XLaunchNewImage(file.c_str(),0);
	}
	return S_OK;
}
